/*
	File:		DotDrivers.h

	Contains:	Definition of Dot Printer drivers

	Copyright:	 1992-1995 by Apple Computer, Inc., all rights reserved.

	Derived from v12 internal.

*/


#ifndef __DOTDRIVERS_H
#define __DOTDRIVERS_H

// define debugLevel before including Newton.h
#ifdef forDebug
	#ifdef __TestPrinting
		#define debugLevel 2
		#define PrintDebug
	#endif
#endif

#ifndef __CONFIGPRINTING_H
#include "ConfigPrinting.h"
#endif

#ifndef __NEWTON_H
#include "Newton.h"
#endif

#ifndef __PRINTTYPES_H
#include "PrintTypes.h"
#endif

#ifndef __PRINTERRORS_H
#include "PrintErrors.h"
#endif

#ifndef __DRIVERCALLBACKS_H
#include "DriverCallbacks.h"
#endif

#ifndef __OBJECTS_H
#include "Objects.h"
#endif

#ifndef __PROTOCOLS_H
#include "Protocols.h"
#endif



class TPrinter;


PROTOCOL TDotPrinterDriver : public TProtocol
{
public:
	void Delete(void);

	NewtonErr	Open(void);
	NewtonErr	Close(void);
	NewtonErr	OpenPage(void);
	NewtonErr	ClosePage(void);
	NewtonErr	ImageBand(PixelMap* theBand, const Rect* minRect);
	void		CancelJob(Boolean asyncCancel);

	PrProblemResolution	IsProblemResolved(void);

	void 		GetPageInfo(PrPageInfo* info);
	void 		GetBandPrefs(DotPrinterPrefs* prefs);

	/****** version 2.0 method ******/

	NewtonErr 	FaxEndPage(long pageCount);

	PrintConnect*	fConnect;
	TPrinter*		fPrinter;
};

#endif
